*-----------------------------------------------------------
* Program    :
* Written by :
* Date       :
* Description:	Type Str
*-----------------------------------------------------------
*
StrBufISFN	equ	1
*
	ORG	*
*
*
*============= StrDec (chvec:ptr, val:long, fldsiz:long ):vecptr =================
*	Returns Chvec with decimal character equivalent of val appended to chvec
*	If chvec is null then returns null
*	If fldsiz <= 0 then returns chvec as passed
*	If curix(chvec)+fldsiz > maxix(chvec) then returns chvec as passed
*	if fldsiz will not contain converted value then returns 
*	chvec with fldsiz *'s appended
*	if fldsiz has more bytes than needed for converted value then 
*	pads with leading spaces before bytes of converted value 
StrDec:
*
	OFFSET	0
_std_Result	DS.L	1
_std_PrvFrm	DS.L	1
_std_chvec	DS.L	1
_std_val	DS.L	1
_std_fldsz	DS.L	1
_std_RetPC	DS.L	1
_std_curix	DS.L	1
_std_i		DS.L	1
_std_myval	DS.L	1
_std_quotient	DS.L	1
_std_rem	DS.L	1
_std_q		DS.L	1
_std_r		DS.L	1
_std_zerosig	DS.L	1
	ORG	*
*
*	if (Result = chvec) == null) then 
	move.l	-_std_chvec(a6),d0
	move.l	d0,-_std_Result(a6)
	bne	stdnotnull
stdret:
*		return Result
		move.l	-_std_RetPC(a6),a0
		jmp	(a0)
*	endif
stdnotnull:
*	if ((d1 = fldsz) <= 0) then return
	move.l	-_std_fldsz(a6),d1
	ble	stdret
*	endif
*
*	curix = VecCurIx(chvec)
	mark
		move.l	d0,-(a7)
		lea.l	VecCurIx,a0
		jsr	(a0)
	unmark				* curix allocated in tos
*
*	i = VecMaxix(chvec)
	halfmark
		move.l	-_std_chvec(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecMaxIx,a0
		jsr	(a0)
	unmark				* i=maxix allocated in tos
*
*	if VecEltI(chvec,curix,true)==NUL then \\trim trailing null off chvec if any
	halfmark
		move.l	-_std_chvec(a6),-(a7)
		move.l	-_std_curix(a6),-(a7)
		lea.l	MARKBYTS+LNGBYTS(a7),a6
		moveq.l	#1,d0
		move.l	d0,-(a7)
		lea.l	VecEltI,a0
		jsr	(a0)
	unmark
	move.l	(a7)+,d0
	bne	std0
*		curix --
		move.l	-_std_curix(a6),d0
		subq.l	#1,d0
		move.l	d0,-_std_curix(a6)
*		drop = VecSetCurIx(chvec,curix)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			move.l	d0,-(a7)
			lea.l	VecSetCurIx,a0
			jsr	(a0)
		unmarkdrop
*	endif
std0:
*
*	if curix+fldsz > i then return
	move.l	-_std_i(a6),d0
	move.l	-_std_curix(a6),d1
	add.l	-_std_fldsz(a6),d1
	cmp.l	d0,d1
	bgt	stdret
*
*	cnt = 0			* Major long section sets cnt = amount chars needed
	clr.l	d0
*	if (myval = val) == -2147483647 then
	move.l	-_std_val(a6),d1
	move.l	d1,-(a7)	* myval allocated in tos
	cmpi.l	#80000000,d1
	bne	std1
*		cnt = 11
		move.l	#11,d0
*	else if val < 0 then
	bra	stdcntdn
std1:
	tst.l	d1
	bgt	std3
*		val = - val	* convert val to positive
		neg.l	d1
		move.l	d1,-_std_val(a6)
*		cnt = cnt+1	* bump cnt for place for minus
		addq.l	#1,d0
*	endif
std3:
*	if val >= 1,000,000,000 then
	cmpi.l	#1000000000,d1
	blt	std4
*		cnt += 10
		addi.l	#10,d0
*	else if val >= 100,000,000 then
	bra	stdcntdn
std4:
	cmpi.l	#100000000,d1
	blt	std5
*		cnt += 9
		addi.l	#9,d0
*	else if val >= 10,000,000 then 
	bra	stdcntdn
std5:
	cmpi.l	#10000000,d1
	blt	std6
*		cnt += 8
		addi.l	#8,d0
*	else if val >= 1,000,000 then
	bra	stdcntdn
std6:
	cmpi.l	#1000000,d1
	blt	std7
*		cnt += 7
		addi.l	#7,d0
* 	else if val >= 100,000 then 
	bra	stdcntdn
std7:
	cmpi.l	#100000,d1
	blt	std8
*		cnt += 6
		addi.l	#6,d0
*	else if val > 10,000 then
	bra	stdcntdn
std8:
	cmpi.l	#10000,d1
	blt	std9
*		cnt += 5
		addi.l	#5,d0
*	else if val > 1,000 then 
	bra	stdcntdn
std9:
	cmpi.l	#1000,d1
	blt	std10
*		cnt += 4
		addi.l	#4,d0
*	else if val > 100 then
	bra	stdcntdn
std10:
	cmpi.l	#100,d1
	blt	std11
*		cnt += 3
		addi.l	#3,d0
*	else if val > 10 then
	bra	stdcntdn
std11:
	cmpi.l	#10,d1
	blt	std12 
*		cnt += 2
		addi.l	#2,d0
*	else
	bra	stdcntdn
std12:
*		cnt += 1
		addi.l	#1,d0
*	endif
stdcntdn:
*
*	d0 = cnt - fldsz 		* Section handles padding or star fill
	move.l	-_std_fldsz(a6),d2
	sub.l	d2,d0

*	if d0 > 0 then 
	ble	std13
stdstars:
*		for i = 1 to fldsz do
			moveq.l	#0,d0
			move.l	d0,-_std_i(a6)
std14:
*			drop = VecAppend(chvec,0,'*')
			halfmark
				move.l	-_std_chvec(a6),-(a7)
				lea.l	MARKBYTS(a7),a6
				move.l	#Char_STAR,d0
				clr.l	-(a7)
				move.l	d0,-(a7)
				lea.l	VecAppend,a0
				jsr	(a0)
			unmarkdrop
*		end
		move.l	-_std_i(a6),d0
		addq.l	#1,d0
		move.l	d0,-_std_i(a6)
		cmp.l	-_std_fldsz(a6),d0
		blt	std14
*		goto stdret
	bra	stdret
*	else if cnt > 0 then
std13:
	beq	std14a
		
*		for i = cnt to 0 do
		move.l	d0,-_std_i(a6)
std15:
*			drop = VecAppend(chvec,0,' ')
			halfmark
				move.l	-_std_chvec(a6),-(a7)
				lea.l	MARKBYTS(a7),a6
				clr.l	-(a7)
				move.l	#Char_SPACE,-(a7)
				lea.l	VecAppend,a0
				jsr	(a0)
			unmarkdrop
*		end
		move.l	-_std_i(a6),d0
		addq.l	#1,d0
		move.l	d0,-_std_i(a6)
		blt	std15
*	endif
std14a:
*
*	if myval < 0 then 
	tst.l	-_std_myval(a6)
	bge	std14aa
*		drop = VecAppend(chvec,0,'-')
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	#Char_MINUS,d0
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*	endif
std14aa:
*					* Rest of routine generates the digits
*					* Max negative has no inverse so star fill
*	quotient = val
	move.l	-_std_val(a6),d0
	move.l	d0,-(a7)	* quotient
*	rem = 0
	clr.l	-(a7)		* rem
*	q = 0
	clr.l	-(a7)		* q
*	r = 0
	clr.l	-(a7)		* r
*	zerosig	= 0
	clr.l	-(a7)		* zerosig
*	if val = -21473648 then goto stdstars endif
	cmpi.l	#$80000000,d0
	beq	stdstars	
*
*				* Manually whittle down to < 655,350,000 so can use divu
*	if val >= 2000000000 then 
	cmpi.l	#2000000000,d0
	blt	std14b
*		quotient = val - 2000000000
		subi.l	#2000000000,d0
		move.l	d0,-_std_quotient(a6)
*		d1 = '2'
		move.l	#'2',d1
*		goto	std14c
		bra	std14c
std14b:
*	else if val >= 1000000000 then
	cmpi.l	#1000000000,d0
	blt	std14d
*		quotient = val - 1000000000
		subi.l	#1000000000,d0
		move.l	d0,-_std_quotient(a6)
*		d1 = '1'
		move.l	#'1',d1
std14c:
*		drop = VecAppend(chvec,null,d1)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d1,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	endif
std14d:
*	if quotient > 900000000 then
	move.l	-_std_quotient(a6),d0
	cmpi.l	#900000000,d0
	blt	std14e
*		quotient = val - 900000000
		subi.l	#900000000,d0
,d0
		move.l	d0,-_std_quotient(a6)
*		d1 = '9'
		move.l	#'9',d1
		bra	std14h
*	else if quotient > 800000000 then
std14e:
	move.l	-_std_quotient(a6),d0
	cmpi.l	#800000000,d0
	blt	std14f
*		quotient = val - 800000000
		subi.l	#800000000,d0
		move.l	d0,-_std_quotient(a6)
*		d1 = '8'
		move.l	#'8',d1
		bra	std14h
*	else if quotient > 700000000 then
std14f:
	move.l	-_std_quotient(a6),d0
	cmpi.l	#700000000,d0
	blt	std14g
*		quotient = val - 700000000
		subi.l	#700000000,d0
		move.l	d0,-_std_quotient(a6)
*		d1 = '7'
		move.l	#'7',d1
		bra	std14h
*	else if quotient > 600000000 then
std14g:
	move.l	-_std_quotient(a6),d0
	cmpi.l	#600000000,d0
	blt	std14i
*		quotient = val - 600000000
		subi.l	#600000000,d0
		move.l	d0,-_std_quotient(a6)
*		d1 = '6'
		move.l	#'6',d1
		bra	std14h
std14h:
*		drop = VecAppend(chvec,null,d1)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d1,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	endif
std14i:
*		
*	* Quotient < 65,535 * 10,000 so can use divu by 10,000 w/o overflow
*	quotient=quotient/10000;rem=rem(quotient/10000)
	move.l	-_std_quotient(a6),d0
	clr.l	-_std_quotient(a6)
	clr.l	-_std_rem(a6)
	divu	#10000,d0
	swap.w  d0
	move.w	d0,-_std_rem+WRDBYTS(a6)
	clr.w	d0
	swap.w	d0
	move.w	d0,-_std_quotient+WRDBYTS(a6)
*	if zerosig then goto std14ii
	tst.l	-_std_zerosig(a6)
	bne	std14ii
	tst.l	d0
	ble	std30
std14ii:
*	  if zerosig or quotient > 10000 then
	  move.l	#10000,d1 
	  tst.l		-_std_zerosig(a6)
	  bne		std14j
	  cmp.l 	d1,d0
	  ble		std20
std14j:
*		q=quotient/10000; r=rem(quotient/10000)
		divu	d1,d0
		clr.w	-_std_q(a6)
		move.w	d0,-_std_q+WRDBYTS(a6)
		clr.w	d0
		swap.w	d0
		move.l	d0,-_std_r(a6)
*		tos = CharAsc(q)
		halfmark
			move.l	-_std_q(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	CharAsc,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d0
*		drop =VecAppend(chval,0,tos)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		quotient =  r
		move.l	-_std_r(a6),d0
		move.l	d0,-_std_quotient(a6)	
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	  endif
std20:
*	  if zerosig or quotient > 1000 then
	  move.l	#1000,d1 
	  tst.l		-_std_zerosig(a6)
	  bne		std20a
	  cmp.l 	d1,d0
	  ble		std21
std20a:
*		q=quotient/1000; r=rem(quotient/1000)
		divu	d1,d0
		clr.w	-_std_q(a6)
		move.w	d0,-_std_q+WRDBYTS(a6)
		clr.w	d0
		swap.w	d0
		move.l	d0,-_std_r(a6)
*		tos = CharAsc(q)
		halfmark
			move.l	-_std_q(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	CharAsc,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d0
*		drop =VecAppend(chval,0,tos)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		quotient =  r
		move.l	-_std_r(a6),d0
		move.l	d0,-_std_quotient(a6)
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	  endif
std21:
*	  if zerosig or quotient > 100 then
	  move.l	#100,d1 
	  tst.l		-_std_zerosig(a6)
	  bne		std21a
	  cmp.l 	d1,d0
	  ble		std22
std21a:
*		q=quotient/100; r=rem(quotient/100)
		divu	d1,d0
		clr.w	-_std_q(a6)
		move.w	d0,-_std_q+WRDBYTS(a6)
		clr.w	d0
		swap.w	d0
		move.l	d0,-_std_r(a6)
*		tos = CharAsc(q)
		halfmark
			move.l	-_std_q(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	CharAsc,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d0
*		drop =VecAppend(chval,0,tos)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		quotient =  r
		move.l	-_std_r(a6),d0
		move.l	d0,-_std_quotient(a6)
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	  endif
std22:
*	  if zerosig or quotient > 10 then
	  move.l	#10,d1 
	  tst.l		-_std_zerosig(a6)
	  bne		std22a
	  cmp.l 	d1,d0
	  ble		std23
std22a:
*		q=quotient/10; r=rem(quotient/10)
		divu	d1,d0
		clr.w	-_std_q(a6)
		move.w	d0,-_std_q+WRDBYTS(a6)
		clr.w	d0
		swap.w	d0
		move.l	d0,-_std_r(a6)
*		tos = CharAsc(q)
		halfmark
			move.l	-_std_q(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	CharAsc,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d0
*		drop =VecAppend(chval,0,tos)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		quotient =  r
		move.l	-_std_r(a6),d0
		move.l	d0,-_std_quotient(a6)
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	  endif
std23:
*	  if zerosig or quotient > 0 then
	  move.l	-_std_quotient(a6),d0
	  tst.l		-_std_zerosig(a6)
	  bne		std23a
	  tst.l 	d0
	  ble		std30
std23a:
*		tos = CharAsc(d0)
		halfmark
			move.l	d0,-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	CharAsc,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d0
*		drop =VecAppend(chval,0,tos)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	endif
std30:
*	      
*	quotient = rem 
	move.l	-_std_rem(a6),d0
	move.l	d0,-_std_quotient(a6)
*	if zerosig or quotient > 1000 then
	move.l	#1000,d1
	tst.l	-_std_zerosig(a6)
	bne	std24
	cmp.l 	d1,d0
	ble	std25
std24:
*		q=quotient/1000; r=rem(quotient/1000)
		divu	d1,d0
		clr.w	-_std_q(a6)
		move.w	d0,-_std_q+WRDBYTS(a6)
		clr.w	d0
		swap.w	d0
		move.l	d0,-_std_r(a6)
*		tos = CharAsc(q)
		halfmark
			move.l	-_std_q(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	CharAsc,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d0
*		drop =VecAppend(chval,0,tos)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		quotient =  r
		move.l	-_std_r(a6),d0
		move.l	d0,-_std_quotient(a6)
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	endif
std25:
*	if zerosig or quotient > 100 then
	move.l	#100,d1 
	tst.l	-_std_zerosig(a6)
	bne	std25a
	cmp.l 	d1,d0
	ble	std26
std25a:
*		q=quotient/100; r=rem(quotient/100)
		divu	d1,d0
		clr.w	-_std_q(a6)
		move.w	d0,-_std_q+WRDBYTS(a6)
		clr.w	d0
		swap.w	d0
		move.l	d0,-_std_r(a6)
*		tos = CharAsc(q)
		halfmark
			move.l	-_std_q(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	CharAsc,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d0
*		drop =VecAppend(chval,0,tos)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*		quotient =  r
		move.l	-_std_r(a6),d0
		move.l	d0,-_std_quotient(a6)
*		zerosig = true
		move.l	#1,-_std_zerosig(a6)
*	endif
std26:
*	if zerosig or quotient > 10 then
	move.l	#10,d1 
	tst.l	-_std_zerosig(a6)
	bne	std26a
	cmp.l 	d1,d0
	ble	std27
std26a:
*		q=quotient/10; r=rem(quotient/10)
		divu	d1,d0
		clr.w	-_std_q(a6)
		move.w	d0,-_std_q+WRDBYTS(a6)
		clr.w	d0
		swap.w	d0
		move.l	d0,-_std_r(a6)
*		tos = CharAsc(q)
		halfmark
			move.l	-_std_q(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	CharAsc,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d0
*		drop =VecAppend(chval,0,tos)
		halfmark
			move.l	-_std_chvec(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			clr.l	-(a7)
			move.l	d0,-(a7)
			lea.l	VecAppend,a0
			jsr	(a0)
		unmarkdrop
*	endif
std27:			* Last digit is ALWAYS significant
*	tos = CharAsc(r)
	halfmark
		move.l	-_std_r(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	CharAsc,a0
		jsr	(a0)
	unmark
	move.l	(a7)+,d0
*	drop =VecAppend(chval,0,tos)
	halfmark
		move.l	-_std_chvec(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		clr.l	-(a7)
		move.l	d0,-(a7)
		lea.l	VecAppend,a0
		jsr	(a0)
	unmarkdrop
*
*	goto stdret
	bra	stdret	
*	
*
*	StrGetLn (s:ptr): ptr
*	(Only alters contents of s, not input stream stack unless s is in that stack.)
*	Returns s if s is null.
*	If s is not null then fills s from PrtGetRawKey until
*	(1) next-to-last character in s is filled and then puts CR in last one
*	(2) CR is entered before next to last is filled
*	During the filling ^X (CAN) characters empty s and restart filling.
*	During the filling ^H (BS) characters erase the immediately previous
*	filled character (if any).
*	
StrGetLine:
*	if (result = s) == null then return s;
	move.l	-MARKBYTS(a6),(a6)
	tst.l	-MARKBYTS(a6)
	bne	sglfilling
		rts
*	cycle		    \ need to empty buffer due to start or CAN
sglfilling:
*	  VecSetCurix(s,VECMAXIX) \ empty buffer
	  halfmark
	  	move.l	-MARKBYTS(a6),-(a7)
	  	lea.l	MARKBYTS(a7),a6
	  	move.l	#VECEMPTYIX,d0
		move.l	d0,-(a7)
	  	lea.l	VecSetCurIx,a0
	  	jsr	(a0)
	  unmarkdrop
*	  cycle 	    \ 0..n-1 chars in buffer so far w/o CR
sglappending:
*	    if VecCurIx(s) >= VecMaxIX(s)-1 then \ all BS's to date handled
	    halfmark
	    	move.l -MARKBYTS(a6),-(a7)
	    	lea.l	MARKBYTS(a7),a6
	    	lea.l	VecCurIX,a0
	    	jsr	(a0)
	    unmark
	    halfmark
	    	move.l -MARKBYTS(a6),-(a7)
	    	lea.l	MARKBYTS(a7),a6
	    	lea.l	VecMaxIx,a0
	    	jsr	(a0)
	    unmark
	    move.l	(a7)+,d0
	    subq.l	#1,d0
	    move.l	(a7)+,d1
	    cmp.l	d0,d1
	    blt		sglroom
sglexitcrorfull:	
*		\\ here with CR or just filled
		halfmark
	    		move.l -MARKBYTS(a6),-(a7)
	    		lea.l	MARKBYTS(a7),a6
	    		clr.l	-(a7)
	    		clr.l	-(a7)
	    		lea.l	VecAppend,a0
	    		jsr	(a0)
	    	unmarkdrop
		rts
*	    else
sglroom:
*		* there is room for another character and the CR at end
*		d4 = tos+ = PrtGetRawKey()
		mark
			lea.l	PrtGetRawKey,a0
			jsr	(a0)
		unmark
		move.l	(a7)+,d4
*		if d4 = CAN then
		cmpi.l	#Char_CAN,d4
		bne	sgltrybs
*			PrtDispKey(CR)
			mark
				move.l	#Char_CR,d0
				move.l	d0,-(a7)
				lea.l	PrtDispKey,a0
				jsr	(a0)
			unmarkdrop
*			PrtDispKey(LF)
			mark
				move.l	#Char_LF,d0
				move.l	d0,-(a7)
				lea.l	PrtDispKey,a0
				jsr	(a0)
			unmarkdrop
*			goto sglfilling
*		elseif d4 == BS then
sgltrybs:
		cmpi.l	#Char_BS,d4
		bne	sglnobs
*			if (d3 = VecCurIx(s)) >= 0 then
			halfmark
				move.l	-MARKBYTS(a6),-(a7)
				lea.l	MARKBYTS(a7),a6
				lea.l	VecCurIx,a0
				jsr	(a0)
			unmark
			move.l	(a7)+,d3
			blt	sglappending
*				VecSetCurIx(s,d3--)
				halfmark
					move.l	-MARKBYTS(a6),-(a7)
					lea.l	MARKBYTS(a7),a6
					subq.l	#1,d3
					move.l	d3,-(a7)
					lea.l	VecSetCurIx,a0
					jsr	(a0)
				unmarkdrop
*				tos = VecEltI(s,d3,false)
				halfmark
					move.l	-MARKBYTS(a6),-(a7)
					lea.l	MARKBYTS(a7),a6
					move.l	d3,-(a7)
					clr.l	-(a7)
					lea.l	VecEltI,a0
					jsr	(a0)
				unmark			
*				(a0 = tos+) = NUL
				move.l	(a7)+,a0
				clr.b	(a0)
*			endif
*			goto 	sglappending
			bra 	sglappending
*		else \ ch <> BS nor CAN and not overfull
sglnobs:
*			VecAppend(s,0,d4)
			halfmark
				move.l	-MARKBYTS(a6),-(a7)
				lea.l	MARKBYTS(a7),a6
				clr.l	-(a7)
				move.l	d4,-(a7)
				lea.l	VecAppend,a0
				jsr	(a0)
			unmarkdrop			
*			if d4 == CR then
			cmpi.l	#Char_CR,d4 
*				goto sglexitcrorfull
				beq  sglexitcrorfull
*			else
*				goto sglappending
				bra  sglappending
*			endif
*		endif
*	    endif
*	  endcycle
*	endcycle 
*	 
*
*	======== StrNxtCh (strptr:ptr in d6, ChInx: unsigned short in a5): char; ========
*
*	The input stream is currently infinite.  That is there is
* 	no provision for an end-of-file. This routine will get characters
* 	until they are exhausted from any symbolic function bodies
* 	including nested ones, from any include file (includes may not
*	currently be nested), and after exhausting those sources from
*	the interactive user using cooked i/o through the keyboard
*	display port.
*
*	The port is supported as a separate abstraction to enable using 
*	a serial port, terminal, or other hardware device capable of displaying
*	ASCII characters and generating ASCII keystroke input.
*
	OFFSET	0
stResult	DS.L	1	* my result = a6 at call
stPrvFrm	DS.L	1	* my prev frame pointer
stRetPC		DS.L	1	* return PC
	ORG	*
*
StrNxtCh:			* Need another ch
*  cycle			* Have not yet successfully obtained the character
     moveq.l 	  #StrBufISFN,d1 * d1=ISFN mask
     move.l  	  d1,d0 	* d1=ISFN mask
     not.l   	  d0		* d0=SymBuf Addr mask 
     and.l   	  d6,d0		* d0=a0=d6 & d0
     move.l  	  d0,a0		* a0=clean symbuf  
     move.l       a0,-(a7)	* save a0=clean symbuf
*    tos = VecCrIx(a0)
     mark
       move.l	  a0,-(a7) 	* v
       lea.l      VecCurIx,a0
       jsr	  (a0)
     unmark
*    if (a5 < tos) then
     move.l	  (a7)+,d0	* d0 = ix of null at end of symstr
     move.l	  (a7)+,a0	* restore a0=clean symbuf, stk as at entry
     cmp.l	  a5,d0
     ble	  strnxtelse	* Need do pop SymBuf or StrGetLn if at bottom
*      In sym code fn, symbuf or included file and not at end; 
       addq.l	  #1,a5		* SymPC ++ (initially is -1)	
       *  \\ No tests for eols,no tests for escapes in
       *  \\ symcode, they just parse as ctls
       *  return SymBuf[SymPC]
       mark
         move.l   a0,-(a7)	* vec
         move.l   a5,-(a7)	* i
         moveq.l  #1,d0
         move.l   d0,-(a7)	* VAL=TRUE
         lea.l	  VecEltI,a0
         jsr	  (a0)
       unmark
       move.l	  (a7)+,d0
       move.l     d0,-stResult(a6)	* my result = that result
       move.l     -stRetPC(a6),a0
       jmp	  (a0)
*    else
*
strnxtelse:* \\ end sym fn when hit the last char (which is a null)
*      \\ fn or included file marked before call and
*      \\ already set result and already cut back locals
*      if SymStr = SymBuf then
       move.l	  d7,a1
       move.l	  -_GL_SymBuf(a1),d1
       cmp.l      d6,d1		
       bne        stnotbuf 	* stk as at entry her
*
* 	 Do cooked input to SymBuf, NOT in sym function nor included file
*        StrGetLn loops for cooked input       
strgetln:			
	 mark
	 	move.l	a0,-(a7)	* still has clean SymBuf
	 	lea.l	StrGetLine,a0
	 	jsr	(a0)
	 unmarkdrop			* SymBuf is freshly loaded up
	 move.l	#VECEMPTYIX,a5
	 bra	StrNxtCh
*      else 
stnotbuf:  	* Stk as at entry here
*	 Here at end of sym fn, namecalled chlit, or end of buffer in included file
*	 In sym fn will have d6<>-_GL_SymBuf(d7) and d6:0=1
*	 In file buffer will have d6<>-_GL_SymBuf(d7) d6:0=0
*	 if (SymStr && #StrBufISFN) then \\ in included file
	 move.l	#StrBufISFN,d0
	 and.l	d6,d0
	 bne	stnbfsym
*		Here at end of buffer in included file
*		Try to read another one, fid is in Fid
*		Sequenced includes work, nested ones won't due single Fid.
		mark
		    	pea.l	_Fid	* ptr to fid name
		    	move.l	a3,-(a7) 
		    	lea.l	DicSrch,a0
	    		jsr	(a0)
	  	unmark			* ptr to _fid dicent in tos
	  	move.l	(a7)+,d0	* stk as at entry
		mark
			move.l	d0,-(a7) * ptr to fid Dic
			move.l	d6,-(a7) * buf chvec
			lea.l	FilGetLn,a0
			jsr	(a0)
		unmark			* tos <=0 if eof,else bytes
*		if not eof then
		move.l	(a7)+,d0	* stk as at entry
		cmpi.l	#FILOK,d0
		bne	stnbfsym
		    	moveq.l #-1,d0
		    	move.l  d0,a5
		bra	StrNxtCh 	* continue in included file
*		endif
*	 else *	 EOF in included file or end of sym fn
stnbfsym:
*		\\ Stack is as at entry here. 
*		Implement incl file, symfn, namecalled chlit return via stack slide:
*		Update the SymStr and SymPC from the arguments just under my frame
*		and then slide the frame down so that when I return my result is where they 
*		were..
*		(Alternative to stack slide is to return an End-Stream code, e.g. DEL
* 		and have Interp do the frame management.)
*		Pop the two-piece symfn PC back to the loop.
*		Caller must mark and unmark.  
*		(Nested includes would need to re-open and reposition file here
*		or else use new fid for each file.)
		move.l	-stRetPC(a6),a0		 * pop off my RetPC
		  move.l	-stPrvFrm(a6),d0 * pop my PrvFrm
		    move.l	-stResult(a6),d1 * pop off my result
		      lea.l	LNGBYTS(a6),a7	 * cutback to just under my frame
		      move.l	(a7)+,a5	 * Pop the SymPC
		      move.l	(a7)+,d6 	 * Pop the SymStr
		    move.l	d1,-(a7)	 * Put my result back
		    move.l	a7,a6		 * Frame now moved
		  move.l	d0,-(a7)	 * Put my PrvFrm back
		move.l	a0,-(a7)		 * Put my RetPC back
*	 endif \\ included file
*      endif \\ EOF in SymFn or included file
*    endif \\ strnextelse
*  endcycle \\StrNxtCh
   bra     StrNxtCh 
*endfn
*
		ORG	(*+3)&-4
*
*	====================== Name Vectors ================
*
_StrDec		DC.L	_VecAppend
		DC.W	12
		DC.W	7
		DC.B	'_StrDec',0
*
_StrGetLine	DC.L	_StrDec
		DC.W	12
		DC.W	9
		DC.B	'_StrGetLine',0,0,0,0,0
*
_StrNxtCh	DC.L	_StrGetLine
		DC.W	12
		DC.W	9
		DC.B	'_StrNxtCh',0,0,0,0,0,0,0
*
*	====================== Dic Entries =================
__StrDec	DC.L	__VecAppend
		DC.L	_StrDec
		DC.L	StrDec
*
__StrGetLine	DC.L	__StrDec
		DC.L	_StrGetLine
		DC.L	StrGetLine
*
__StrNxtCh	DC.L	__StrGetLine
		DC.L	_StrNxtCh
		DC.L	StrNxtCh


























































































































































































*~Font name~Courier New~
*~Font size~10~
*~Tab type~1~
*~Tab size~8~
